

<?php $__env->startSection('title', 'إدارة الباقات المدفوعة'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">الباقات المدفوعة</h1>
            <p class="text-muted mb-0">إدارة الباقات التي يمكن للمستخدمين شراؤها</p>
        </div>
        <a href="<?php echo e(route('admin.packages.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            إضافة باقة جديدة
        </a>
    </div>

    <div class="card">
        <div class="card-header bg-white border-bottom">
            <h5 class="card-title mb-0">
                <i class="fas fa-box-open text-primary me-2"></i>
                قائمة الباقات (<?php echo e($packages->total()); ?>)
            </h5>
        </div>
        <div class="card-body p-0">
             <?php if($packages->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم الباقة</th>
                                <th>السعر</th>
                                <th>تفتح فئة</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                       <tbody>
    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($package->id); ?></td>
            <td><strong><?php echo e($package->name); ?></strong></td>
            <td><?php echo e($package->price); ?>$</td>
            <td>
                <span class="badge bg-info"><?php echo e($package->questionCategory->name ?? 'لا يوجد'); ?></span>
            </td>
            <td>
                <?php if($package->is_active): ?>
                    <span class="badge bg-success">فعّالة</span>
                <?php else: ?>
                    <span class="badge bg-danger">غير فعّالة</span>
                <?php endif; ?>
            </td>
            <td>
                
                <div class="btn-group btn-group-sm">
                    <a href="<?php echo e(route('admin.packages.edit', $package->id)); ?>" class="btn btn-outline-warning" title="تعديل"><i class="fas fa-edit"></i></a>
                    <button type="button" class="btn btn-outline-danger" onclick="confirmDelete(<?php echo e($package->id); ?>)" title="حذف"><i class="fas fa-trash"></i></button>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
                    </table>
                </div>
            <?php else: ?>
                 <div class="text-center py-5">
                    <h4 class="text-muted">لا توجد باقات بعد</h4>
                    <a href="<?php echo e(route('admin.packages.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>
                        إضافة أول باقة
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد الحذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من حذف هذه الباقة؟</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">نعم، احذف</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function confirmDelete(packageId) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = `<?php echo e(url('admin/packages')); ?>/${packageId}`;
    
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    deleteModal.show();
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\couples_app_api\resources\views\admin\packages\index.blade.php ENDPATH**/ ?>