

<?php $__env->startSection('title', 'إدارة فئات الأسئلة'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">فئات الأسئلة</h1>
            <p class="text-muted mb-0">إضافة وتعديل وحذف فئات الأسئلة</p>
        </div>
        <a href="<?php echo e(route('admin.question-categories.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            إضافة فئة جديدة
        </a>
    </div>

    <div class="card">
        <div class="card-header bg-white border-bottom">
            <h5 class="card-title mb-0">
                <i class="fas fa-tags text-primary me-2"></i>
                قائمة الفئات (<?php echo e($categories->total()); ?>)
            </h5>
        </div>
        <div class="card-body p-0">
            <?php if($categories->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم الفئة</th>
                                <th>الوصف</th>
                                <th class="text-center">عدد الأسئلة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                       <tbody>
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($category->id); ?></td>
            <td><strong><?php echo e($category->name); ?></strong></td>
            <td><?php echo e($category->description ?? '-'); ?></td>
            <td class="text-center">
                <span class="badge bg-secondary"><?php echo e($category->questions_count); ?></span>
            </td>
            <td>
                
                <div class="btn-group btn-group-sm">
                    <a href="<?php echo e(route('admin.question-categories.edit', $category->id)); ?>" class="btn btn-outline-warning" title="تعديل"><i class="fas fa-edit"></i></a>
                    <button type="button" class="btn btn-outline-danger" onclick="confirmDelete(<?php echo e($category->id); ?>)" title="حذف"><i class="fas fa-trash"></i></button>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
                    </table>
                </div>
                 <?php if($categories->hasPages()): ?>
                    <div class="d-flex justify-content-center p-3">
                        <?php echo e($categories->links()); ?>

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-tags fa-4x text-muted mb-4 opacity-25"></i>
                    <h4 class="text-muted">لا توجد فئات بعد</h4>
                    <p class="text-muted mb-4">ابدأ بإضافة أول فئة لتصنيف أسئلتك.</p>
                    <a href="<?php echo e(route('admin.question-categories.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>
                        إضافة أول فئة
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                    تأكيد الحذف
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من حذف هذه الفئة؟</p>
                <p class="text-danger">
                    <small><i class="fas fa-info-circle me-1"></i>
                    لا يمكن التراجع عن هذا الإجراء.</small>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash me-1"></i>
                        حذف نهائياً
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function confirmDelete(categoryId) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = `/admin/question-categories/${categoryId}`; // استخدام URL مباشر
    
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    deleteModal.show();
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\couples_app_api\resources\views\admin\question-categories\index.blade.php ENDPATH**/ ?>