<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GameController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\PackageController; // أضف هذا السطر في الأعلى مع باقي الـ use
use App\Http\Controllers\FavoriteController;

// Public routes (without authentication)
Route::post('/auth/login', [AuthController::class, 'login']);
Route::post('/auth/register', [AuthController::class, 'register']);

    
// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    // Auth & User routes
    Route::post('/auth/logout', [AuthController::class, 'logout']);
    Route::get('/user/profile', [AuthController::class, 'getCurrentUser']);
    Route::put('/user/profile', [AuthController::class, 'updateProfile']);
    Route::post('/user/password', [AuthController::class, 'changePassword']);
    Route::get('/user/stats', [GameController::class, 'getUserStats']);
    Route::get('/favorites', [FavoriteController::class, 'index']);
    Route::post('/favorites/{game}', [FavoriteController::class, 'store']);
    Route::delete('/favorites/{game}', [FavoriteController::class, 'destroy']);
    
    // ✅✅✅ أضف هذا الرابط الجديد للمتجر ✅✅✅
    Route::get('/packages', [PackageController::class, 'index']);

     // Game routes
    Route::get('/games', [GameController::class, 'index']);
    
    // Game session routes
    Route::post('/game-sessions/start', [GameController::class, 'startSession']);
    Route::post('/game-sessions/shared/create', [GameController::class, 'createSharedSession']);
    Route::post('/game-sessions/shared/join', [GameController::class, 'joinSharedSession']);
    Route::get('/game-sessions/{sessionId}/status', [GameController::class, 'getSessionStatus']);
    Route::get('/game-sessions/{session}/questions', [GameController::class, 'getSessionQuestions']);
    Route::post('/game-sessions/{session}/end', [GameController::class, 'endSession']);
    Route::get('/game-sessions/{session}/compatibility', [GameController::class, 'calculateCompatibility']);
    
    // Game answer routes
    Route::post('/game-answers/submit', [GameController::class, 'submitAnswer']);
    Route::post('/game-answers/compare', [GameController::class, 'compareAnswers']);

    // ✅ الرابط الجديد الذي أضفته وهو في مكانه الصحيح
    Route::get('/game-sessions/{session}/question/{question}/status', [GameController::class, 'getQuestionStatus']);
    
    // Packages route (مثال)
    // Route::get('/packages', [PackageController::class, 'index']);

});

// Test route
Route::get('/test', function () {
    return response()->json([
        'success' => true,
        'message' => 'API is working!',
        'timestamp' => now()
    ]);
});