@extends('admin.layouts.app')

@section('title', 'تعديل باقة')

@section('content')
<div class="container-fluid">
     <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-1">تعديل الباقة: {{ $package->name }}</h1>
        <a href="{{ route('admin.packages.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            العودة
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.packages.update', $package->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-8 mb-3">
                        <label for="name" class="form-label">اسم الباقة <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" value="{{ old('name', $package->name) }}" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="price" class="form-label">السعر (بالدولار) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" class="form-control" name="price" value="{{ old('price', $package->price) }}" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">الوصف (اختياري)</label>
                    <textarea class="form-control" name="description" rows="2">{{ old('description', $package->description) }}</textarea>
                </div>

                <div class="mb-3">
                    <label for="unlocks_question_category_id" class="form-label">الفئة التي تفتحها الباقة <span class="text-danger">*</span></label>
                    <select class="form-select" name="unlocks_question_category_id" required>
                        <option value="">-- اختر فئة --</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('unlocks_question_category_id', $package->unlocks_question_category_id) == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <hr>
                <p class="text-muted">المعرفات الخاصة بمتاجر التطبيقات (اختياري الآن)</p>
                <div class="row">
                     <div class="col-md-4 mb-3">
                        <label for="product_id_apple" class="form-label">Apple Product ID</label>
                        <input type="text" class="form-control" name="product_id_apple" value="{{ old('product_id_apple', $package->product_id_apple) }}">
                    </div>
                     <div class="col-md-4 mb-3">
                        <label for="product_id_google" class="form-label">Google Product ID</label>
                        <input type="text" class="form-control" name="product_id_google" value="{{ old('product_id_google', $package->product_id_google) }}">
                    </div>
                     <div class="col-md-4 mb-3">
                        <label for="product_id_gateway" class="form-label">Gateway Product ID</label>
                        <input type="text" class="form-control" name="product_id_gateway" value="{{ old('product_id_gateway', $package->product_id_gateway) }}">
                    </div>
                </div>
                
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" name="is_active" value="1" {{ old('is_active', $package->is_active) ? 'checked' : '' }}>
                    <label class="form-check-label" for="is_active">تفعيل الباقة</label>
                </div>
                
                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection