@extends('admin.layouts.app')

@section('title', 'لوحة التحكم الرئيسية')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">لوحة التحكم الرئيسية</h1>
            <p class="text-muted mb-0">مرحباً بك في لوحة إدارة تطبيق الأزواج</p>
        </div>
        <div class="text-muted">
            <i class="fas fa-calendar-alt me-2"></i>
            {{ now()->format('Y/m/d - H:i') }}
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card text-white" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">إجمالي المستخدمين</h6>
                            <h2 class="mb-0">{{ $stats['total_users'] }}</h2>
                        </div>
                        <div class="opacity-50">
                            <i class="fas fa-users fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <small class="text-white-50">
                            <i class="fas fa-arrow-up me-1"></i>
                            نشط منذ الإطلاق
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card text-white" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">الألعاب المتاحة</h6>
                            <h2 class="mb-0">{{ $stats['total_games'] }}</h2>
                        </div>
                        <div class="opacity-50">
                            <i class="fas fa-gamepad fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <small class="text-white-50">
                            <i class="fas fa-plus me-1"></i>
                          الألعاب المتاحة
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card text-white" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">إجمالي الأسئلة</h6>
                            <h2 class="mb-0">{{ $stats['total_questions'] }}</h2>
                        </div>
                        <div class="opacity-50">
                            <i class="fas fa-question-circle fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <small class="text-white-50">
                            <i class="fas fa-edit me-1"></i>
                            قابلة للتعديل
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card text-white" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">جلسات اللعب</h6>
                            <h2 class="mb-0">{{ $stats['total_sessions'] }}</h2>
                        </div>
                        <div class="opacity-50">
                            <i class="fas fa-play-circle fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <small class="text-white-50">
                            <i class="fas fa-check me-1"></i>
                            {{ $stats['completed_sessions'] }} مكتملة
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Recent Users -->
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-user-plus text-primary me-2"></i>
                            المستخدمون الجدد
                        </h5>
                        <a href="{{ route('admin.users.index') }}" class="btn btn-sm btn-outline-primary">
                            عرض الكل
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if($stats['recent_users']->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($stats['recent_users'] as $user)
                                <div class="list-group-item border-0 px-0">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar me-3">
                                            <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                <i class="fas fa-user text-white"></i>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">{{ $user->name }}</h6>
                                            <small class="text-muted">{{ $user->email }}</small>
                                        </div>
                                        <div class="text-muted">
                                            <small>{{ $user->created_at->diffForHumans() }}</small>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-4 text-muted">
                            <i class="fas fa-users fa-3x mb-3 opacity-25"></i>
                            <p>لا يوجد مستخدمون جدد</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Recent Game Sessions -->
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-play text-success me-2"></i>
                            جلسات اللعب الحديثة
                        </h5>
                        <span class="badge bg-success">{{ $stats['recent_sessions']->count() }}</span>
                    </div>
                </div>
                <div class="card-body">
                    @if($stats['recent_sessions']->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($stats['recent_sessions'] as $session)
                                <div class="list-group-item border-0 px-0">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <div class="bg-{{ $session->status === 'completed' ? 'success' : 'warning' }} rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                                <i class="fas fa-{{ $session->status === 'completed' ? 'check' : 'clock' }} text-white fa-sm"></i>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">{{ $session->game->name ?? 'لعبة محذوفة' }}</h6>
                                            <small class="text-muted">
                                                بواسطة {{ $session->user->name ?? 'مستخدم محذوف' }}
                                                @if($session->status === 'completed')
                                                    - {{ $session->score }} نقطة
                                                @endif
                                            </small>
                                        </div>
                                        <div class="text-muted">
                                            <small>{{ $session->created_at->diffForHumans() }}</small>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-4 text-muted">
                            <i class="fas fa-gamepad fa-3x mb-3 opacity-25"></i>
                            <p>لا توجد جلسات لعب حديثة</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row g-4 mt-2">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-white border-bottom">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-bolt text-warning me-2"></i>
                        إجراءات سريعة
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <a href="{{ route('admin.questions.create') }}" class="btn btn-outline-primary w-100 py-3">
                                <i class="fas fa-plus-circle fa-2x d-block mb-2"></i>
                                إضافة سؤال جديد
                            </a>
                        </div>
                       
                        <div class="col-md-3">
                            <a href="{{ route('admin.admins.create') }}" class="btn btn-outline-info w-100 py-3">
                                <i class="fas fa-user-shield fa-2x d-block mb-2"></i>
                                إضافة مدير جديد
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="{{ route('admin.analytics.index') }}" class="btn btn-outline-warning w-100 py-3">
                                <i class="fas fa-chart-bar fa-2x d-block mb-2"></i>
                                عرض الإحصائيات
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection