<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema; // ✅ تأكد من وجود هذا السطر

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // 1. إيقاف التحقق من العلاقات بين الجداول مؤقتاً
        Schema::disableForeignKeyConstraints();

        // 2. تفريغ الجداول من أي بيانات قديمة
        \App\Models\Game::truncate();
        \App\Models\Question::truncate();
        \App\Models\QuestionCategory::truncate();
        \App\Models\Admin::truncate();
        
        // 3. استدعاء كل الـ Seeders لملء الجداول ببيانات جديدة
        $this->call([
            GameSeeder::class,
            QuestionSeeder::class,
            AdminSeeder::class,
        ]);

        // 4. إعادة تفعيل التحقق من العلاقات
        Schema::enableForeignKeyConstraints();
    }
}