<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('game_sessions', function (Blueprint $table) {
            // الفهارس الموجودة مسبقاً
            $table->index('join_code');
            $table->index('status');
            $table->index(['session_type', 'status']);

            // ✅✅✅ أضف هذه الفهارس الجديدة ✅✅✅
            $table->index('user_id');
            $table->index('partner_id');
            $table->index('game_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('game_sessions', function (Blueprint $table) {
            // يمكنك إضافة كود الحذف هنا إذا أردت
        });
    }
};