<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم الباقة، مثال: "باقة الأسئلة الجريئة"
            $table->text('description')->nullable(); // وصف قصير للباقة
            $table->decimal('price', 8, 2); // السعر، مثال: 9.99

            // هذا هو الحقل الذي يربط الباقة بفئة الأسئلة التي تفتحها
            $table->foreignId('unlocks_question_category_id')->nullable()->constrained('question_categories')->onDelete('set null');

            // === الحقول المرنة لمعرفات الدفع ===
            // هذه الحقول سنتركها فارغة الآن حتى يقرر العميل طريقة الدفع
            $table->string('product_id_apple')->nullable(); // معرّف المنتج في متجر آبل
            $table->string('product_id_google')->nullable(); // معرّف المنتج في متجر جوجل
            $table->string('product_id_gateway')->nullable(); // معرّف المنتج في أي بوابة خارجية

            $table->boolean('is_active')->default(true); // لتفعيل أو إلغاء تفعيل الباقة
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};