<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('game_sessions', function (Blueprint $table) {
            $table->id();
            
            // الأعمدة الخاصة باللعب المشترك
            $table->string('join_code')->nullable()->unique();
            $table->string('session_type')->default('single');

            // اللاعبون
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('partner_id')->nullable()->constrained('users')->onDelete('set null');

            // معلومات اللعبة
            $table->foreignId('game_id')->constrained('games')->onDelete('cascade');
            $table->integer('total_questions')->default(10);
            $table->integer('correct_answers')->default(0);
            $table->integer('score')->default(0);

            // حالة الجلسة: pending, waiting, active, completed
            $table->string('status')->default('pending'); 
            
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('game_sessions');
    }
};
