<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasApiTokens;

    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'avatar',
        'gender',
        'birth_date',
        'language',
        'is_active',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'birth_date' => 'date',
            'is_active' => 'boolean',
        ];
    }

    // دالة لجلب كل جلسات اللعب الخاصة بالمستخدم
    public function gameSessions()
    {
        return $this->hasMany(\App\Models\GameSession::class);
    }

    // ✅ إصلاح: دالة لحساب مجموع النقاط من جدول game_sessions
    public function getTotalScore()
    {
        return $this->hasMany(\App\Models\GameSession::class)
            ->where('status', 'completed')  // ✅ توحيد: نستخدم status مثل GameController
            ->sum('score');
    }

    // ✅ إصلاح: دالة لحساب عدد الألعاب المكتملة
    public function getGamesPlayedCount()
    {
        return $this->hasMany(\App\Models\GameSession::class)
            ->where('status', 'completed')  // ✅ توحيد: نستخدم status مثل GameController
            ->count();
    }
    public function favorites()
{
    return $this->belongsToMany(Game::class, 'favorite_games');
}

}