<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    use HasFactory;

    protected $fillable = [
        'question_text',
        'options',
        'correct_answer',
        'question_category_id',
    ];

    protected $casts = [
        'options' => 'array', // ✅ هذا يحول JSON تلقائياً لـ array
    ];

    // العلاقة مع QuestionCategory
    public function category()
    {
        return $this->belongsTo(QuestionCategory::class, 'question_category_id');
    }
}