<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Game extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'image_path',
        'type',
        'max_questions',
        'difficulty_level',
        'icon',
        'color',
        'is_active',
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['image_url'];

    /**
     * ✅✅✅ هذه الدالة هي الحل لمشكلة الصور ✅✅✅
     * تقوم بإنشاء رابط كامل للصورة تلقائياً
     *
     * @return string|null
     */
   public function getImageUrlAttribute()
{
    if ($this->image_path) {
        // ✅ غير 'asset' إلى 'url' لتستخدم الرابط الجديد من web.php
        return url('storage/' . $this->image_path);
    }
    return null;
}
// في ملف Game.php
public function favoritedBy()
{
    return $this->belongsToMany(User::class, 'favorite_games');
}
}