<?php
// app/Models/Couple.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Couple extends Model
{
    use HasFactory;

    protected $fillable = [
        'user1_id',
        'user2_id', 
        'status',
        'couple_name',
        'anniversary_date',
        'is_active'
    ];

    protected $casts = [
        'anniversary_date' => 'date',
        'is_active' => 'boolean'
    ];

    public function user1()
    {
        return $this->belongsTo(User::class, 'user1_id');
    }

    public function user2()
    {
        return $this->belongsTo(User::class, 'user2_id');
    }
}

// app/Models/Question.php  
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'question_text',
        'question_type',
        'options',
        'difficulty_level',
        'points',
        'is_active'
    ];

    protected $casts = [
        'options' => 'array',
        'points' => 'integer',
        'is_active' => 'boolean'
    ];

    public function category()
    {
        return $this->belongsTo(QuestionCategory::class, 'category_id');
    }

    public function gameAnswers()
    {
        return $this->hasMany(GameAnswer::class);
    }
}

// app/Models/QuestionCategory.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuestionCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'icon',
        'color',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    public function questions()
    {
        return $this->hasMany(Question::class, 'category_id');
    }
}

// app/Models/Game.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Game extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description', 
        'icon',
        'color',
        'max_questions',
        'time_limit',
        'difficulty_level',
        'is_active'
    ];

    protected $casts = [
        'max_questions' => 'integer',
        'time_limit' => 'integer',
        'is_active' => 'boolean'
    ];

    public function sessions()
    {
        return $this->hasMany(GameSession::class);
    }
}

// app/Models/GameSession.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GameSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'game_id',
        'user_id',
        'partner_id',
        'status',
        'score',
        'total_questions',
        'correct_answers',
        'started_at',
        'completed_at'
    ];

    protected $casts = [
        'score' => 'integer',
        'total_questions' => 'integer', 
        'correct_answers' => 'integer',
        'started_at' => 'datetime',
        'completed_at' => 'datetime'
    ];

    public function game()
    {
        return $this->belongsTo(Game::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function partner()
    {
        return $this->belongsTo(User::class, 'partner_id');
    }

    public function answers()
    {
        return $this->hasMany(GameAnswer::class, 'session_id');
    }

    public function results()
    {
        return $this->hasMany(GameResult::class, 'session_id');
    }
}

// app/Models/GameAnswer.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GameAnswer extends Model
{
    use HasFactory;

    protected $fillable = [
        'session_id',
        'question_id',
        'user_answer',
        'partner_answer',
        'is_correct',
        'points_earned',
        'answered_at'
    ];

    protected $casts = [
        'is_correct' => 'boolean',
        'points_earned' => 'integer',
        'answered_at' => 'datetime'
    ];

    public function session()
    {
        return $this->belongsTo(GameSession::class, 'session_id');
    }

    public function question()
    {
        return $this->belongsTo(Question::class);
    }
}

// app/Models/Achievement.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Achievement extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'icon', 
        'color',
        'points',
        'condition_type',
        'condition_value',
        'is_active'
    ];

    protected $casts = [
        'points' => 'integer',
        'condition_value' => 'integer',
        'is_active' => 'boolean'
    ];

    public function users()
    {
        return $this->belongsToMany(User::class, 'couple_achievements')
                   ->withTimestamps();
    }
}