<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ImageController extends Controller
{
    public function show($path)
    {
        // التحقق من أن الملف موجود في storage/app/public
        if (!Storage::disk('public')->exists($path)) {
            abort(404);
        }

        // إرجاع الملف مباشرة من الـ Storage
        // هذا سيجبر الطلب على المرور عبر Laravel وتطبيق CORS Middleware
        return Storage::disk('public')->response($path);
    }
}